/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingbinding.adapters;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.beansbinding.ext.BeanAdapterProvider;
import org.jdesktop.swingbinding.adapters.BeanAdapterBase;
import org.jdesktop.swingbinding.impl.ListBindingManager;

public final class JListAdapterProvider
implements BeanAdapterProvider {
    private static final String SELECTED_ELEMENT_P = "selectedElement";
    private static final String SELECTED_ELEMENTS_P = "selectedElements";
    private static final String SELECTED_ELEMENT_IA_P = "selectedElement_IGNORE_ADJUSTING";
    private static final String SELECTED_ELEMENTS_IA_P = "selectedElements_IGNORE_ADJUSTING";

    private static List<Object> getSelectedElements(JList list) {
        assert (list != null);
        ListSelectionModel selectionModel = list.getSelectionModel();
        int min = selectionModel.getMinSelectionIndex();
        int max = selectionModel.getMaxSelectionIndex();
        if (min < 0 || max < 0) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> elements = new ArrayList<Object>(max - min + 1);
        for (int i = min; i <= max; ++i) {
            if (!selectionModel.isSelectedIndex(i)) continue;
            elements.add(JListAdapterProvider.getElement(list, i));
        }
        return elements;
    }

    private static Object getSelectedElement(JList list) {
        assert (list != null);
        int index = list.getSelectionModel().getLeadSelectionIndex();
        int n = index = list.getSelectionModel().isSelectedIndex(index) ? index : list.getSelectionModel().getMinSelectionIndex();
        if (index == -1) {
            return null;
        }
        return JListAdapterProvider.getElement(list, index);
    }

    private static Object getElement(JList list, int index) {
        ListModel model = list.getModel();
        return model instanceof ListBindingManager ? ((ListBindingManager)((Object)model)).getElement(index) : model.getElementAt(index);
    }

    @Override
    public boolean providesAdapter(Class<?> type, String property) {
        if (!JList.class.isAssignableFrom(type)) {
            return false;
        }
        return (property = property.intern()) == SELECTED_ELEMENT_P || property == SELECTED_ELEMENT_IA_P || property == SELECTED_ELEMENTS_P || property == SELECTED_ELEMENTS_IA_P;
    }

    @Override
    public Object createAdapter(Object source, String property) {
        if (!this.providesAdapter(source.getClass(), property)) {
            throw new IllegalArgumentException();
        }
        return new Adapter((JList)source, property);
    }

    @Override
    public Class<?> getAdapterClass(Class<?> type) {
        return JList.class.isAssignableFrom(type) ? Adapter.class : null;
    }

    public final class Adapter
    extends BeanAdapterBase {
        private JList list;
        private Handler handler;
        private Object cachedElementOrElements;

        private Adapter(JList list, String property) {
            super(property);
            this.list = list;
        }

        private boolean isPlural() {
            return this.property == JListAdapterProvider.SELECTED_ELEMENTS_P || this.property == JListAdapterProvider.SELECTED_ELEMENTS_IA_P;
        }

        public Object getSelectedElement() {
            return JListAdapterProvider.getSelectedElement(this.list);
        }

        public Object getSelectedElement_IGNORE_ADJUSTING() {
            return this.getSelectedElement();
        }

        public List<Object> getSelectedElements() {
            return JListAdapterProvider.getSelectedElements(this.list);
        }

        public List<Object> getSelectedElements_IGNORE_ADJUSTING() {
            return this.getSelectedElements();
        }

        @Override
        protected void listeningStarted() {
            this.handler = new Handler();
            this.cachedElementOrElements = this.isPlural() ? this.getSelectedElements() : this.getSelectedElement();
            this.list.addPropertyChangeListener("model", this.handler);
            this.list.addPropertyChangeListener("selectionModel", this.handler);
            this.list.getSelectionModel().addListSelectionListener(this.handler);
        }

        @Override
        protected void listeningStopped() {
            this.list.getSelectionModel().removeListSelectionListener(this.handler);
            this.list.removePropertyChangeListener("model", this.handler);
            this.list.removePropertyChangeListener("selectionModel", this.handler);
            this.cachedElementOrElements = null;
            this.handler = null;
        }

        private class Handler
        implements ListSelectionListener,
        PropertyChangeListener {
            private Handler() {
            }

            private void listSelectionChanged() {
                Object oldElementOrElements = Adapter.this.cachedElementOrElements;
                Adapter.this.cachedElementOrElements = Adapter.this.isPlural() ? Adapter.this.getSelectedElements() : Adapter.this.getSelectedElement();
                Adapter.this.firePropertyChange(oldElementOrElements, Adapter.this.cachedElementOrElements);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if ((Adapter.this.property == JListAdapterProvider.SELECTED_ELEMENT_IA_P || Adapter.this.property == JListAdapterProvider.SELECTED_ELEMENTS_IA_P) && e.getValueIsAdjusting()) {
                    return;
                }
                this.listSelectionChanged();
            }

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                String propertyName = pce.getPropertyName();
                if (propertyName == "selectionModel") {
                    ((ListSelectionModel)pce.getOldValue()).removeListSelectionListener(Adapter.this.handler);
                    ((ListSelectionModel)pce.getNewValue()).addListSelectionListener(Adapter.this.handler);
                    this.listSelectionChanged();
                } else if (propertyName == "model") {
                    this.listSelectionChanged();
                }
            }
        }
    }
}

